/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.hmcservc;

import com.ibm.hwmca.base.hmcservc.HmcServicesErrorIds;
import com.ibm.hwmca.base.settings.network.FirewallAdmin;
import com.ibm.hwmca.base.settings.network.FirewallAdminException;
import com.ibm.hwmca.fw.interfaces.OpticalPAProvider;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.Tower;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.rsf.RemoteSupportFacility;
import com.ibm.hwmca.fw.rsf.RsfManager;
import com.ibm.hwmca.fw.upgrddat.MigrateOS2Data;
import com.ibm.hwmca.fw.upgrddat.UpgradeDataException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Set;

public class HmcServicesData
implements HmcServicesErrorIds,
MigrateOS2Data {
    private static final String TRACE_MASKT = "HSRVDATT";
    private static final String TRACE_MASKF = "HSRVDATF";
    private static final String TRACE_MASKD = "HSRVDATD";
    private static FrameworkClassLogInfo logInfo;
    private static final String PERSIST_KEY = "com.ibm.hwmca.base.hmcservc.HmcServicesData";
    private static HmcServicesData instance;
    private HmcServicesPersistentData data = null;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$Tower;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$interfaces$OpticalPAProvider;

    private HmcServicesData() {
        this.data = new HmcServicesPersistentData();
        this.data.remoteOperationEnabled = false;
        this.data.phoneServerEnabled = false;
        this.data.opticalEnabled = false;
        this.data.callAnsEnabled = false;
        this.data.licChangeEnabled = false;
    }

    private HmcServicesData(HmcServicesPersistentData data) {
        this.data = data;
    }

    public static HmcServicesData getHmcServicesData() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteOperationEnabled(boolean remoteOperationEnabled) {
        Trace.trace(TRACE_MASKT, "--> setRemoteOperationEnabled(" + remoteOperationEnabled + ")");
        HmcServicesPersistentData hmcServicesPersistentData = this.data;
        synchronized (hmcServicesPersistentData) {
            boolean wasEnabled = this.data.remoteOperationEnabled;
            this.data.remoteOperationEnabled = remoteOperationEnabled;
            this.persistData();
            Trace.trace(TRACE_MASKF, "setRemoteOperationEnabled: enabled=" + this.data.remoteOperationEnabled + " wasEnabled=" + wasEnabled);
            if (this.data.remoteOperationEnabled) {
                if (!wasEnabled) {
                    try {
                        Trace.trace(TRACE_MASKF, "setRemoteOperationEnabled: enabling web ports");
                        FirewallAdmin.getFirewallAdmin().enableWebPorts();
                    }
                    catch (FirewallAdminException e) {
                        Trace.trace(TRACE_MASKF, e);
                    }
                }
            } else if (wasEnabled) {
                try {
                    Trace.trace(TRACE_MASKF, "setRemoteOperationEnabled: disabling web ports");
                    FirewallAdmin.getFirewallAdmin().disableWebPorts();
                }
                catch (FirewallAdminException e) {
                    Trace.trace(TRACE_MASKF, e);
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<-- setRemoteOperationEnabled()");
    }

    public boolean isRemoteOperationEnabled() {
        Trace.trace(TRACE_MASKT, "<-> isRemoteOperationEnabled()");
        return this.data.remoteOperationEnabled;
    }

    public void setPhoneServerEnabled(boolean phoneServerEnabled) {
        Trace.trace(TRACE_MASKT, "--> setPhoneServerEnabled(" + phoneServerEnabled + ")");
        RemoteSupportFacility rsf = RsfManager.getRsfManager().getConsoleRsf();
        if (rsf != null) {
            rsf.setCallHomeServerEnabled(phoneServerEnabled);
        }
        Trace.trace(TRACE_MASKT, "<-- setPhoneServerEnabled()");
    }

    public boolean isPhoneServerEnabled() {
        Trace.trace(TRACE_MASKT, "<-> isPhoneServerEnabled()");
        RemoteSupportFacility rsf = RsfManager.getRsfManager().getConsoleRsf();
        if (rsf != null) {
            return rsf.isCallHomeServerEnabled();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOpticalEnabled(boolean opticalEnabled) {
        Trace.trace(TRACE_MASKT, "--> setOpticalEnabled(" + opticalEnabled + ")");
        HmcServicesPersistentData hmcServicesPersistentData = this.data;
        synchronized (hmcServicesPersistentData) {
            this.data.opticalEnabled = opticalEnabled;
            this.persistData();
            ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
            Set inventory = mom.getInventory(new ClassId(class$com$ibm$hwmca$fw$managed$Tower == null ? (class$com$ibm$hwmca$fw$managed$Tower = HmcServicesData.class$("com.ibm.hwmca.fw.managed.Tower")) : class$com$ibm$hwmca$fw$managed$Tower));
            Tower[] towerArray = inventory.toArray(new Tower[inventory.size()]);
            Trace.trace(TRACE_MASKD, "got " + towerArray.length + " towers to work with");
            int i = 0;
            while (i < towerArray.length) {
                block9: {
                    Trace.trace(TRACE_MASKD, "get the optical impl");
                    OpticalPAProvider optPro = (OpticalPAProvider)towerArray[i].getInterfaceImpl(class$com$ibm$hwmca$fw$interfaces$OpticalPAProvider == null ? HmcServicesData.class$("com.ibm.hwmca.fw.interfaces.OpticalPAProvider") : class$com$ibm$hwmca$fw$interfaces$OpticalPAProvider);
                    if (optPro != null) {
                        try {
                            if (opticalEnabled) {
                                Trace.trace(TRACE_MASKD, "enable Optical PA");
                                optPro.enableOpticalPA();
                                Trace.trace(TRACE_MASKD, "done");
                                break block9;
                            }
                            Trace.trace(TRACE_MASKD, "disable Optical PA");
                            optPro.disableOpticalPA();
                            Trace.trace(TRACE_MASKD, "done");
                        }
                        catch (Exception e) {
                            Trace.trace(TRACE_MASKD, "got an exception");
                            Trace.trace(TRACE_MASKD, e);
                            new FrameworkLog(logInfo, 8, e).log();
                        }
                    } else {
                        Trace.trace(TRACE_MASKD, "didn't have the interface");
                    }
                }
                ++i;
            }
            Trace.trace(TRACE_MASKD, "done");
            Trace.trace(TRACE_MASKT, "<-- setOpticalEnabled()");
        }
    }

    public boolean isOpticalEnabled() {
        Trace.trace(TRACE_MASKT, "<-> isOpticalEnabled()");
        return this.data.opticalEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallAnsEnabled(boolean callAnsEnabled) {
        Trace.trace(TRACE_MASKT, "--> setCallAnsEnabled(" + callAnsEnabled + ")");
        HmcServicesPersistentData hmcServicesPersistentData = this.data;
        synchronized (hmcServicesPersistentData) {
            this.data.callAnsEnabled = callAnsEnabled;
            this.persistData();
        }
        Trace.trace(TRACE_MASKT, "<-- setCallAnsEnabled()");
    }

    public boolean isCallAnsEnabled() {
        Trace.trace(TRACE_MASKT, "<-> isCallAnsEnabled()");
        return this.data.callAnsEnabled;
    }

    private void persistData() {
        Trace.trace(TRACE_MASKT, "--> persistData()");
        try {
            PersistenceManager manager = PersistenceManager.getPersistenceManager();
            manager.write(PERSIST_KEY, this.data);
        }
        catch (Exception e) {
            new FrameworkLog(logInfo, 7, e).log();
        }
        Trace.trace(TRACE_MASKT, "<-- persistData()");
    }

    public void restoreOS2Data(Object os2Data, String simName) throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "-> restoreOS2Data(" + os2Data + "," + simName + ")");
        byte[] data = (byte[])os2Data;
        if (simName.equals("XMRC_ROF_ENABLED")) {
            this.setRemoteOperationEnabled(data[0] != 0);
        } else if (simName.equals("XMRC_PA_FOCAL_POINT")) {
            this.setOpticalEnabled(data[0] != 0);
        } else if (simName.equals("XMRC_DLC_ACTIVE")) {
            this.setCallAnsEnabled(data[0] != 0);
        }
        Trace.trace(TRACE_MASKT, "<- restoreOS2Data()");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        block3: {
            logInfo = new FrameworkClassLogInfo(-42, "HmcServcData");
            instance = null;
            try {
                PersistenceManager pm = PersistenceManager.getPersistenceManager();
                if (pm.contains(PERSIST_KEY)) {
                    instance = new HmcServicesData((HmcServicesPersistentData)pm.read(PERSIST_KEY));
                    break block3;
                }
                instance = new HmcServicesData();
            }
            catch (Exception e) {
                instance = new HmcServicesData();
                new FrameworkLog(logInfo, 6, e).log();
            }
        }
    }

    private static class HmcServicesPersistentData
    implements Persistable,
    PersistentData {
        private static final long serialVersionUID = 1L;
        public boolean remoteOperationEnabled;
        public boolean phoneServerEnabled;
        public boolean opticalEnabled;
        public boolean callAnsEnabled;
        public boolean licChangeEnabled;

        public HmcServicesPersistentData() {
        }

        public HmcServicesPersistentData(PersistentData data) {
            HmcServicesPersistentData newData = (HmcServicesPersistentData)data;
            this.remoteOperationEnabled = newData.remoteOperationEnabled;
            this.phoneServerEnabled = newData.phoneServerEnabled;
            this.opticalEnabled = newData.opticalEnabled;
            this.callAnsEnabled = newData.callAnsEnabled;
            this.licChangeEnabled = newData.licChangeEnabled;
        }

        public PersistentData getPersistentData() {
            return this;
        }

        public boolean isUpgradeData() {
            return true;
        }

        public String toString() {
            return "remoteOperationEnabled: " + this.remoteOperationEnabled + "\n" + "opticalEnabled: " + this.opticalEnabled + "\n" + "callAnsEnabled: " + this.callAnsEnabled + "\n";
        }
    }
}

